/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.document;

import org.apache.lucene.ars_nouveau.document.BinaryRangeDocValuesField;
import org.apache.lucene.ars_nouveau.document.DoubleRange;
import org.apache.lucene.ars_nouveau.document.DoubleRangeSlowRangeQuery;
import org.apache.lucene.ars_nouveau.document.RangeFieldQuery;
import org.apache.lucene.ars_nouveau.search.Query;

public class DoubleRangeDocValuesField
extends BinaryRangeDocValuesField {
    final String field;
    final double[] min;
    final double[] max;

    public DoubleRangeDocValuesField(String field, double[] min, double[] max) {
        super(field, DoubleRange.encode(min, max), min.length, 8);
        DoubleRangeDocValuesField.checkArgs(min, max);
        this.field = field;
        this.min = min;
        this.max = max;
    }

    public double getMin(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.min[dimension];
    }

    public double getMax(int dimension) {
        if (dimension > 4 || dimension > this.min.length) {
            throw new IllegalArgumentException("Dimension out of valid range");
        }
        return this.max[dimension];
    }

    private static Query newSlowRangeQuery(String field, double[] min, double[] max, RangeFieldQuery.QueryType queryType) {
        DoubleRangeDocValuesField.checkArgs(min, max);
        return new DoubleRangeSlowRangeQuery(field, min, max, queryType);
    }

    public static Query newSlowIntersectsQuery(String field, double[] min, double[] max) {
        return DoubleRangeDocValuesField.newSlowRangeQuery(field, min, max, RangeFieldQuery.QueryType.INTERSECTS);
    }

    private static void checkArgs(double[] min, double[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        for (int i = 0; i < min.length; ++i) {
            if (!(min[i] > max[i])) continue;
            throw new IllegalArgumentException("min should be less than max");
        }
    }
}

